/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Dictionary
extends MIDlet
implements CommandListener {
    TextBox mainMenu;
    static Command QUIT_CMD = new Command("\u0412\u0438\u0445i\u0434", 7, 2);
    static Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static Command TRANSLATE_CMD = new Command("\u0428\u0443\u043a\u0430\u0442\u0438", 4, 1);
    static Command ORDER_BY_FREQUENCY_CMD = new Command("\u0417\u0430 \u0447\u0430\u0441\u0442\u043e\u0442\u043e\u044e", 8, 1);
    static Command ORDER_BY_TIME_CMD = new Command("\u0417\u0430 \u0447\u0430\u0441\u043e\u043c", 8, 1);
    static final int MAX_LENGTH = 32;
    static final int MAX_FILE_SIZE = 32768;
    static final int SELECTION_LIMIT = 32;
    static final char SEPARATOR = ';';
    Volume[] volumes;
    int nVolumes;
    byte[] buf = new byte[32768];
    int prevVolumeSize;
    int prevVolumeIndex;
    Vector translatedWords = new Vector();

    public Dictionary() {
        this.mainMenu = new TextBox("\u041d\u0430\u0437\u0432\u0430 \u0432\u0443\u043b\u0438\u0446\u0456", "", 32, 0);
        this.mainMenu.addCommand(QUIT_CMD);
        this.mainMenu.addCommand(TRANSLATE_CMD);
        this.buildIndex();
    }

    protected void destroyApp(boolean bl) {
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    static String rusLowerCase(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= 'A' && c <= 'Z' || c >= '\u0410' && c <= '\u042f') {
                int n = i;
                cArray[n] = (char)(cArray[n] + 32);
                continue;
            }
            if (c == '\u0406') {
                cArray[i] = 1110;
            }
            if (c == '\u0407') {
                cArray[i] = 1111;
            }
            if (c != '\u0404') continue;
            cArray[i] = 1108;
        }
        return new String(cArray);
    }

    static String rusLowerCase1(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '\u0410' && c <= '\u0415') {
                int n2 = i;
                cArray[n2] = (char)(cArray[n2] + 32);
            }
            if (c == '\u0404') {
                cArray[i] = 1078;
            }
            if (c >= '\u0416' && c <= '\u0418') {
                int n3 = i;
                cArray[n3] = (char)(cArray[n3] + 33);
            }
            if (c == '\u0406') {
                cArray[i] = 1081;
            }
            if (c == '\u0407') {
                cArray[i] = 1082;
            }
            if (c >= '\u0419' && c <= '\u042f') {
                int n4 = i;
                cArray[n4] = (char)(cArray[n4] + 35);
            }
            if (c == '\u0454') {
                cArray[i] = 1078;
            }
            if (c >= '\u0436' && c <= '\u0438') {
                int n5 = i;
                cArray[n5] = (char)(cArray[n5] + '\u0001');
            }
            if (c == '\u0456') {
                cArray[i] = 1081;
            }
            if (c == '\u0457') {
                cArray[i] = 1082;
            }
            if (c >= '\u0439' && c <= '\u044f') {
                int n6 = i;
                cArray[n6] = (char)(cArray[n6] + 3);
            }
            if (c != '\'') continue;
            cArray[i] = cArray[i + 1];
            --i;
            --n;
        }
        return new String(cArray);
    }

    static String getString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i];
            cArray[i] = (char)(n3 < 0 ? (n3 == -81 ? 1031 : (n3 == -86 ? 1028 : (n3 == -70 ? 1108 : (n3 == -77 ? 1110 : (n3 == -65 ? 1111 : (n3 == -78 ? 1030 : 0x400 | (n3 & 0x7F) - 48)))))) : (n3 == 124 ? (n3 = 10) : n3));
        }
        return new String(cArray);
    }

    static int getUnicodeStringLength(byte[] byArray, int n) {
        while (byArray[n++] != 10) {
        }
        return n;
    }

    static String getUnicodeString(byte[] byArray, int n) {
        int n2;
        int n3;
        byte[] byArray2 = new byte[32768];
        for (n3 = 0; n3 <= n; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        n3 = n;
        if (byArray[n3] != 59) {
            byArray2[n3] = 40;
            ++n3;
            while (byArray[n3 - 1] != 59) {
                byArray2[n3] = byArray[n3 - 1];
                ++n3;
            }
            byArray2[n3] = 41;
            byArray2[n3 + 1] = 58;
            byArray2[n3 + 2] = 10;
            n3 += 3;
            n2 = 3;
        } else {
            byArray2[n3] = 32;
            byArray2[n3 + 1] = 10;
            n3 += 2;
            n2 = 1;
        }
        while (byArray[n3 - n2] != 59) {
            byArray2[n3] = byArray[n3 - n2];
            ++n3;
        }
        byArray2[n3] = 10;
        byArray2[++n3] = 40;
        while (byArray[n3 - n2 + 1] != 10) {
            byArray2[++n3] = byArray[n3 - n2 - 1];
        }
        byArray2[n3] = byArray[n3 - n2 - 1];
        byArray2[n3 + 1] = 41;
        byArray2[n3 + 2] = 10;
        return Dictionary.getString(byArray2, n, (n3 += 2) - n);
    }

    private void buildIndex() {
        int n;
        int n2;
        Object object;
        try {
            object = ((Object)((Object)this)).getClass().getResourceAsStream("/dictionary.idx");
            n2 = ((InputStream)object).read(this.buf);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            throw new Error("Failed to read index");
        }
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            Volume volume = new Volume();
            int n3 = n;
            while (this.buf[n3] != 59) {
                ++n3;
            }
            volume.first = Dictionary.getString(this.buf, n, n3 - n);
            n = ++n3;
            while (this.buf[n] != 10) {
                ++n;
            }
            volume.last = Dictionary.getString(this.buf, n3, n - n3);
            ((Vector)object).addElement(volume);
        }
        this.nVolumes = ((Vector)object).size();
        this.volumes = new Volume[this.nVolumes];
        this.prevVolumeIndex = -1;
        for (n = 0; n < this.nVolumes; ++n) {
            this.volumes[n] = (Volume)((Vector)object).elementAt(n);
        }
    }

    public Vector getSelection(String string) {
        if (this.nVolumes == 0) {
            this.buildIndex();
        }
        Vector<Translation> vector = new Vector<Translation>();
        int n = this.nVolumes;
        Volume[] volumeArray = this.volumes;
        boolean bl = false;
        try {
            int n2 = 0;
            String string2 = Dictionary.rusLowerCase1(volumeArray[n2].last);
            while (n2 < n && string2.compareTo(Dictionary.rusLowerCase1(string)) < 0) {
                string2 = Dictionary.rusLowerCase1(volumeArray[++n2].last);
            }
            while (n2 < n) {
                int n3;
                Object object;
                if (this.prevVolumeIndex != n2) {
                    object = ((Object)((Object)this)).getClass().getResourceAsStream("volume." + (n2 + 1));
                    n3 = ((InputStream)object).read(this.buf);
                    this.prevVolumeIndex = n2;
                    this.prevVolumeSize = n3;
                    ((InputStream)object).close();
                } else {
                    n3 = this.prevVolumeSize;
                }
                object = Dictionary.rusLowerCase1(volumeArray[n2].first);
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = n4;
                    while (this.buf[n4] != 59) {
                        ++n4;
                    }
                    String string3 = Dictionary.getString(this.buf, n5, n4 - n5);
                    n5 = ++n4;
                    n4 = Dictionary.getUnicodeStringLength(this.buf, n4);
                    String string4 = Dictionary.rusLowerCase1(string3);
                    if (string4.compareTo(Dictionary.rusLowerCase1(string)) >= 0) {
                        if (string4.startsWith(Dictionary.rusLowerCase1(string))) {
                            bl = true;
                        } else if (bl) {
                            return vector;
                        }
                        String string5 = " " + Dictionary.getUnicodeString(this.buf, n5);
                        vector.addElement(new Translation(string3, string5));
                        if (vector.size() == 32) {
                            return vector;
                        }
                    }
                    object = string4;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            String string = this.mainMenu.getString();
            if (string.length() == 0) {
                if (this.translatedWords.size() > 0) {
                    new TranslatedList(this);
                }
            } else {
                this.mainMenu.setTitle("\u0427\u0435\u043a\u0430\u0439\u0442\u0435");
                this.mainMenu.setString("\u0419\u0434\u0435 \u043f\u043e\u0448\u0443\u043a...");
                Vector vector = this.getSelection(string);
                switch (vector.size()) {
                    case 0: {
                        Alert alert = new Alert(string, "\u041d\u0435\u043c\u0430 \u0432\u0430\u0440i\u0430\u043d\u0442i\u0432", null, AlertType.ERROR);
                        alert.setTimeout(-2);
                        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
                        break;
                    }
                    case 1: {
                        Translation translation = (Translation)vector.firstElement();
                        if (translation.word.equals(string)) {
                            new TranslationBox(this, (Displayable)this.mainMenu, (Translation)vector.firstElement());
                            break;
                        }
                    }
                    default: {
                        new PrefixList(this, (Displayable)this.mainMenu, vector);
                    }
                }
                this.mainMenu.setTitle("\u041d\u0430\u0437\u0432\u0430 \u0432\u0443\u043b\u0438\u0446\u0456");
                this.mainMenu.setString(string);
            }
        }
    }

    class Volume {
        String first;
        String last;

        Volume() {
        }
    }
}

